/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.GroupConcat;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.SQLServerFunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b=\u0010>J+\u0010\b\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ;\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J1\u0010\u0017\u001a\u00020\u0007\"\n\b\u0000\u0010\u0002*\u0004\u0018\u00010\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J+\u0010\u0019\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0019\u0010\tJ+\u0010\u001a\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001a\u0010\tJ+\u0010\u001b\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001b\u0010\tJ\u001f\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010%\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b%\u0010&J\u0019\u0010(\u001a\u00020\u000e2\b\u0010'\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b(\u0010)JG\u0010-\u001a\u00020\u0007\"\n\b\u0000\u0010\u0002*\u0004\u0018\u00010\u000e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010,\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b-\u0010.J+\u0010/\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b/\u0010\tJY\u00108\u001a\u00020\u000e2\u0006\u00101\u001a\u0002002\u001e\u00106\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u000304\u0012\u0006\u0012\u0004\u0018\u00010503022\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u0001072\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b8\u00109JY\u00108\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\f2\u001e\u00106\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u000304\u0012\u0006\u0012\u0004\u0018\u00010503022\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u0001072\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b8\u0010;J+\u0010<\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b<\u0010\t\u00a8\u0006?"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerFunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "T", "Lorg/jetbrains/exposed/sql/Expression;", "expr", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "", "day", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "", "ignore", "Lorg/jetbrains/exposed/sql/Table;", "table", "", "where", "", "limit", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "delete", "(ZLorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/GroupConcat;", "groupConcat", "(Lorg/jetbrains/exposed/sql/GroupConcat;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "hour", "minute", "month", "Lorg/jetbrains/exposed/sql/Sequence;", "seq", "builder", "nextVal", "(Lorg/jetbrains/exposed/sql/Sequence;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "size", "", "offset", "alreadyOrdered", "queryLimit", "(IJZ)Ljava/lang/String;", "seed", "random", "(Ljava/lang/Integer;)Ljava/lang/String;", "expr1", "pattern", "caseSensitive", "regexp", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/Expression;ZLorg/jetbrains/exposed/sql/QueryBuilder;)V", "second", "Lorg/jetbrains/exposed/sql/Join;", "targets", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Column;", "", "columnsAndValues", "Lorg/jetbrains/exposed/sql/Op;", "update", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "target", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "year", "<init>", "()V", "exposed-core"})
public final class SQLServerFunctionProvider
extends FunctionProvider {
    @NotNull
    public static final SQLServerFunctionProvider INSTANCE = new SQLServerFunctionProvider();

    private SQLServerFunctionProvider() {
    }

    @Override
    public void nextVal(@NotNull Sequence seq, @NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(seq){
            final /* synthetic */ Sequence $seq;
            {
                this.$seq = $seq;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                Object[] objectArray = new Object[]{"NEXT VALUE FOR ", this.$seq.getIdentifier()};
                ExpressionKt.append($this$invoke, objectArray);
            }
        }));
    }

    @Override
    @NotNull
    public String random(@Nullable Integer seed) {
        return seed != null ? "RAND(" + seed + ')' : "RAND(CHECKSUM(NEWID()))";
    }

    @Override
    public <T extends String> void groupConcat(@NotNull GroupConcat<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Transaction tr = TransactionManager.Companion.current();
        if (expr.getSeparator() == null) {
            ExceptionsKt.throwUnsupportedException(tr, "SQLServer requires explicit separator in STRING_AGG.");
            throw new KotlinNothingValueException();
        }
        if (expr.getOrderBy().length > 1) {
            ExceptionsKt.throwUnsupportedException(tr, "SQLServer supports only single column in ORDER BY clause in STRING_AGG.");
            throw new KotlinNothingValueException();
        }
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ GroupConcat<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.append("STRING_AGG(");
                $this$invoke.append(this.$expr.getExpr());
                $this$invoke.append(", '" + this.$expr.getSeparator() + "')");
                Pair pair = (Pair)ArraysKt.singleOrNull((Object[])this.$expr.getOrderBy());
                if (pair != null) {
                    Pair $dstr$col$order = pair;
                    boolean bl = false;
                    Expression col = (Expression)$dstr$col$order.component1();
                    SortOrder order = (SortOrder)((Object)$dstr$col$order.component2());
                    Object[] objectArray = new Object[]{" WITHIN GROUP (ORDER BY ", col, " ", order.name(), ")"};
                    ExpressionKt.append($this$invoke, objectArray);
                }
            }
        }));
    }

    @Override
    public <T extends String> void regexp(@NotNull Expression<T> expr1, @NotNull Expression<String> pattern, boolean caseSensitive, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr1, (String)"expr1");
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        ExceptionsKt.throwUnsupportedException(TransactionManager.Companion.current(), "SQLServer doesn't provide built in REGEXP expression, use LIKE instead.");
        throw new KotlinNothingValueException();
    }

    @Override
    public <T> void year(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(YEAR, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        }));
    }

    @Override
    public <T> void month(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(MONTH, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        }));
    }

    @Override
    public <T> void day(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(DAY, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        }));
    }

    @Override
    public <T> void hour(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(HOUR, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        }));
    }

    @Override
    public <T> void second(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(SECOND, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        }));
    }

    @Override
    public <T> void minute(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(MINUTE, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        }));
    }

    @Override
    @NotNull
    public String update(@NotNull Table target, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(columnsAndValues, (String)"columnsAndValues");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        String def = super.update(target, columnsAndValues, null, where, transaction2);
        return limit != null ? StringsKt.replaceFirst$default((String)def, (String)"UPDATE", (String)("UPDATE TOP(" + limit + ')'), (boolean)false, (int)4, null) : def;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        boolean bl;
        Table tableToUpdate;
        QueryBuilder $this$update_u24lambda_u2d4;
        block11: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
            Intrinsics.checkNotNullParameter(columnsAndValues, (String)"columnsAndValues");
            Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
            $this$update_u24lambda_u2d4 = new QueryBuilder(true);
            boolean bl2 = false;
            Iterable $this$map$iv = columnsAndValues;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(((Column)it.getFirst()).getTable());
            }
            Table table = (Table)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
            if (table == null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "SQLServer supports a join updates with a single table columns to update.");
                throw new KotlinNothingValueException();
            }
            tableToUpdate = table;
            Iterable $this$any$iv = targets.getJoinParts$exposed_core();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Join.JoinPart it = (Join.JoinPart)element$iv;
                    boolean bl4 = false;
                    if (!(it.getJoinType() != JoinType.INNER)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            SQLLogKt.getExposedLogger().warn("All tables in UPDATE statement will be joined with inner join");
        }
        if (limit != null) {
            $this$update_u24lambda_u2d4.unaryPlus("UPDATE TOP(" + limit + ')');
        } else {
            $this$update_u24lambda_u2d4.unaryPlus("UPDATE ");
        }
        tableToUpdate.describe(transaction2, $this$update_u24lambda_u2d4);
        $this$update_u24lambda_u2d4.unaryPlus(" SET ");
        ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u2d4, null, null, null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(transaction2){
            final /* synthetic */ Transaction $transaction;
            {
                this.$transaction = $transaction;
                super(2);
            }

            public final void invoke(@NotNull QueryBuilder $this$appendTo, @NotNull Pair<? extends Column<?>, ? extends Object> $dstr$col$value) {
                Intrinsics.checkNotNullParameter((Object)$this$appendTo, (String)"$this$appendTo");
                Intrinsics.checkNotNullParameter($dstr$col$value, (String)"$dstr$col$value");
                Column col = (Column)$dstr$col$value.component1();
                Object value2 = $dstr$col$value.component2();
                $this$appendTo.append(Intrinsics.stringPlus((String)this.$transaction.fullIdentity(col), (Object)"="));
                $this$appendTo.registerArgument(col, value2);
            }
        }, 14, null);
        $this$update_u24lambda_u2d4.unaryPlus(" FROM ");
        if (!Intrinsics.areEqual((Object)targets.getTable(), (Object)tableToUpdate)) {
            targets.getTable().describe(transaction2, $this$update_u24lambda_u2d4);
        }
        ExpressionKt.appendTo$default(targets.getJoinParts$exposed_core(), $this$update_u24lambda_u2d4, ",", null, null, (Function2)new Function2<QueryBuilder, Join.JoinPart, Unit>(tableToUpdate, transaction2){
            final /* synthetic */ Table $tableToUpdate;
            final /* synthetic */ Transaction $transaction;
            {
                this.$tableToUpdate = $tableToUpdate;
                this.$transaction = $transaction;
                super(2);
            }

            public final void invoke(@NotNull QueryBuilder $this$appendTo, @NotNull Join.JoinPart it) {
                Intrinsics.checkNotNullParameter((Object)$this$appendTo, (String)"$this$appendTo");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)it.getJoinPart(), (Object)this.$tableToUpdate)) {
                    it.getJoinPart().describe(this.$transaction, $this$appendTo);
                }
            }
        }, 12, null);
        $this$update_u24lambda_u2d4.unaryPlus(" WHERE ");
        ExpressionKt.appendTo$default(targets.getJoinParts$exposed_core(), $this$update_u24lambda_u2d4, " AND ", null, null, update.1.4.INSTANCE, 12, null);
        Op<Boolean> op = where;
        if (op != null) {
            Op<Boolean> it = op;
            boolean bl5 = false;
            $this$update_u24lambda_u2d4.unaryPlus(" AND ");
            $this$update_u24lambda_u2d4.unaryPlus((Expression)it);
        }
        Integer n = limit;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl6 = false;
            $this$update_u24lambda_u2d4.unaryPlus(Intrinsics.stringPlus((String)" LIMIT ", (Object)it));
        }
        return $this$update_u24lambda_u2d4.toString();
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Table table, @Nullable String where, @Nullable Integer limit, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        String def = super.delete(ignore, table, where, null, transaction2);
        return limit != null ? StringsKt.replaceFirst$default((String)def, (String)"DELETE", (String)("DELETE TOP(" + limit + ')'), (boolean)false, (int)4, null) : def;
    }

    @Override
    @NotNull
    public String queryLimit(int size, long offset, boolean alreadyOrdered) {
        return (alreadyOrdered ? "" : " ORDER BY(SELECT NULL)") + " OFFSET " + offset + " ROWS FETCH NEXT " + size + " ROWS ONLY";
    }
}

